/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.DelayBuffer;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;

public class ModifiedHodgkinHuxleyModel
implements IHodgkinHuxleyModel {
    private double elapsedTime = 0.0;
    private double v;
    private double dv;
    private double cm;
    private double gk;
    private double gna;
    private double gl;
    private double n;
    private double m;
    private double h;
    private double dn;
    private double dm;
    private double dh;
    private double an;
    private double bn;
    private double am;
    private double bm;
    private double ah;
    private double bh;
    private double vk;
    private double vna;
    private double vl;
    private double n4;
    private double m3h;
    private double na_current;
    private double k_current;
    private double l_current;
    private double timeRemainder;
    public float perNaChannels = 100.0f;
    public float perKChannels = 100.0f;
    private double timeSinceActionPotential = Double.POSITIVE_INFINITY;
    private DelayBuffer m3hDelayBuffer = new DelayBuffer(0.001, 2.2222222222222223E-5);
    private DelayBuffer n4DelayBuffer = new DelayBuffer(0.001, 2.2222222222222223E-5);
    private final double resting_v = 65.0;
    private boolean vClampOn = false;
    float vClampValue = this.convertV(0.0f);

    public ModifiedHodgkinHuxleyModel() {
        this.reset();
    }

    public void reset() {
        this.n4DelayBuffer.clear();
        this.m3hDelayBuffer.clear();
        this.cm = 1.0;
        this.v = 0.0;
        this.vna = -115.0;
        this.vk = 12.0;
        this.vl = 0.0;
        this.gna = this.perNaChannels * 120.0f / 100.0f;
        this.gk = this.perKChannels * 36.0f / 100.0f;
        this.gl = 0.3;
        this.bh = 1.0 / (Math.exp((this.v + 30.0) / 10.0) + 1.0);
        this.ah = 0.07 * Math.exp(this.v / 20.0);
        this.bm = 4.0 * Math.exp(this.v / 18.0);
        this.am = 0.1 * (this.v + 25.0) / (Math.exp((this.v + 25.0) / 10.0) - 1.0);
        this.bn = 0.125 * Math.exp(this.v / 80.0);
        this.an = 0.01 * (this.v + 10.0) / (Math.exp((this.v + 10.0) / 10.0) - 1.0);
        this.n = this.an / (this.an + this.bn);
        this.m = this.am / (this.am + this.bm);
        this.h = this.ah / (this.ah + this.bh);
        this.timeSinceActionPotential = Double.POSITIVE_INFINITY;
    }

    public double get_n4() {
        return this.n4;
    }

    public double get_delayed_n4(double d) {
        if (d <= 0.0) {
            return this.n4;
        }
        return this.n4DelayBuffer.getDelayedValue(d);
    }

    public double get_m3h() {
        return this.m3h;
    }

    public double get_delayed_m3h(double d) {
        double d2 = 0.0;
        d2 = d <= 0.0 ? this.m3h : this.m3hDelayBuffer.getDelayedValue(d);
        return d2;
    }

    public double get_na_current() {
        return -1.0 * this.na_current;
    }

    public double get_k_current() {
        return -1.0 * this.k_current;
    }

    public double get_l_current() {
        return -1.0 * this.l_current;
    }

    public double get_gk() {
        return this.gk;
    }

    public void set_gk(double d) {
        this.gk = d;
    }

    public double get_gna() {
        return this.gna;
    }

    public void set_gna(double d) {
        this.gna = d;
    }

    public double get_gl() {
        return this.gl;
    }

    public void set_gl(double d) {
        this.gl = d;
    }

    public void setV(double d) {
        this.v = -1.0 * d - 65.0;
    }

    public double getV() {
        return -1.0 * (this.v + 65.0);
    }

    public void setCm(double d) {
        this.cm = d;
    }

    public double getCm() {
        return this.cm;
    }

    public double getElapsedTime() {
        return this.elapsedTime;
    }

    public float convertV(float f) {
        return (float)((double)(-1.0f * f) - 65.0);
    }

    public void stepInTime(double d) {
        int n = (int)Math.floor(d * 1000.0 / 0.005);
        this.timeRemainder += d * 1000.0 % 0.005;
        if (this.timeRemainder >= 0.005) {
            ++n;
            this.timeRemainder -= 0.005;
        }
        for (int i = 0; i < n; ++i) {
            this.dh = (this.ah * (1.0 - this.h) - this.bh * this.h) * 0.005;
            this.dm = (this.am * (1.0 - this.m) - this.bm * this.m) * 0.005;
            this.dn = (this.an * (1.0 - this.n) - this.bn * this.n) * 0.005;
            this.bh = 1.0 / (Math.exp((this.v + 30.0) / 10.0) + 1.0);
            this.ah = 0.07 * Math.exp(this.v / 20.0);
            this.dh = (this.ah * (1.0 - this.h) - this.bh * this.h) * 0.005;
            this.bm = 4.0 * Math.exp(this.v / 18.0);
            this.am = 0.1 * (this.v + 25.0) / (Math.exp((this.v + 25.0) / 10.0) - 1.0);
            this.bn = 0.125 * Math.exp(this.v / 80.0);
            this.an = 0.01 * (this.v + 10.0) / (Math.exp((this.v + 10.0) / 10.0) - 1.0);
            this.dm = (this.am * (1.0 - this.m) - this.bm * this.m) * 0.005;
            this.dn = (this.an * (1.0 - this.n) - this.bn * this.n) * 0.005;
            this.n4 = 0.55 * Math.exp(-1.8181818181818181 * Math.pow(this.timeSinceActionPotential - 1.75, 2.0));
            this.m3h = 0.3 * Math.exp(-5.0 * Math.pow(this.timeSinceActionPotential - 1.0, 2.0));
            if (this.n4 < 1.0E-5) {
                this.n4 = 0.0;
            }
            if (this.m3h < 1.0E-5) {
                this.m3h = 0.0;
            }
            this.na_current = this.gna * this.m3h * (this.v - this.vna);
            this.k_current = this.gk * this.n4 * (this.v - this.vk);
            this.l_current = this.gl * (this.v - this.vl);
            this.dv = -0.005 * (this.k_current + this.na_current + this.l_current) / this.cm;
            this.v += this.dv;
            this.h += this.dh;
            this.m += this.dm;
            this.n += this.dn;
            this.elapsedTime += 0.005;
            if (!(this.timeSinceActionPotential < Double.POSITIVE_INFINITY)) continue;
            this.timeSinceActionPotential += 0.005;
        }
        this.m3hDelayBuffer.addValue(this.m3h, d);
        this.n4DelayBuffer.addValue(this.n4, d);
        if (this.vClampOn) {
            this.v = this.vClampValue;
        }
    }

    public double getMembraneVoltage() {
        return this.getV() / 1000.0;
    }

    public void stimulate() {
        this.setV(this.getV() + 15.0);
        this.timeSinceActionPotential = 0.0;
    }
}

