/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.neuron.model.AxonMembrane;
import edu.colorado.phet.neuron.model.CaptureZone;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.IViewableParticle;
import edu.colorado.phet.neuron.model.MembraneChannel;
import edu.colorado.phet.neuron.model.MembraneChannelTypes;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.ModifiedHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.NeuronClock;
import edu.colorado.phet.neuron.model.Particle;
import edu.colorado.phet.neuron.model.ParticleListenerAdapter;
import edu.colorado.phet.neuron.model.ParticlePlaybackMemento;
import edu.colorado.phet.neuron.model.ParticlePosition;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PlaybackParticle;
import edu.colorado.phet.neuron.model.SlowBrownianMotionStrategy;
import edu.colorado.phet.neuron.model.SodiumDualGatedChannel;
import edu.colorado.phet.neuron.model.TimedFadeInStrategy;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuronModel
extends RecordAndPlaybackModel<NeuronModelState>
implements IParticleCapture {
    private static final Random RAND = new Random();
    private static final Rectangle2D PARTICLE_BOUNDS = new Rectangle2D.Double(-90.0, -65.0, 180.0, 130.0);
    private ArrayList<Particle> transientParticles = new ArrayList();
    private ArrayList<Particle> transientParticlesBackup = new ArrayList();
    private ArrayList<Particle> backgroundParticles = new ArrayList();
    private ArrayList<PlaybackParticle> playbackParticles = new ArrayList();
    private final AxonMembrane axonMembrane = new AxonMembrane();
    private final ConstantDtClock clock;
    private ArrayList<MembraneChannel> membraneChannels = new ArrayList();
    private final double crossSectionInnerRadius;
    private final double crossSectionOuterRadius;
    private EventListenerList listeners = new EventListenerList();
    private IHodgkinHuxleyModel hodgkinHuxleyModel = new ModifiedHodgkinHuxleyModel();
    private boolean potentialChartVisible = false;
    private boolean allIonsSimulated = true;
    private boolean chargesShown = false;
    private boolean concentrationReadoutVisible = false;
    private boolean stimulasLockout = false;
    private double previousMembranePotential = 0.0;
    private double sodiumInteriorConcentration = 10.0;
    private double sodiumExteriorConcentration = 145.0;
    private double potassiumInteriorConcentration = 140.0;
    private double potassiumExteriorConcentration = 4.0;
    private boolean playbackParticlesVisible = false;
    private NeuronModelState neuronModelPlaybackState = null;

    public NeuronModel(NeuronClock neuronClock) {
        super((int)Math.ceil(1.125E9));
        this.clock = neuronClock;
        this.crossSectionInnerRadius = (this.axonMembrane.getCrossSectionDiameter() - this.axonMembrane.getMembraneThickness()) / 2.0;
        this.crossSectionOuterRadius = (this.axonMembrane.getCrossSectionDiameter() + this.axonMembrane.getMembraneThickness()) / 2.0;
        neuronClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                NeuronModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }

            public void clockStarted(ClockEvent clockEvent) {
                super.clockStarted(clockEvent);
            }
        });
        neuronClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockListener(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                NeuronModel.this.setPlaybackSpeed(NeuronModel.this.calculatePlaybackSpeed());
            }
        });
        this.addObserver(new SimpleObserver(){

            public void update() {
                NeuronModel.this.updateStimulasLockoutState();
                NeuronModel.this.updateSimAndPlaybackParticleVisibility();
            }
        });
        this.axonMembrane.addListener(new AxonMembrane.Adapter(){

            public void travelingActionPotentialReachedCrossSection() {
                NeuronModel.this.hodgkinHuxleyModel.stimulate();
            }
        });
        this.addInitialChannels();
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    public ArrayList<Particle> getParticles() {
        return this.transientParticles;
    }

    public AxonMembrane getAxonMembrane() {
        return this.axonMembrane;
    }

    public ArrayList<MembraneChannel> getMembraneChannels() {
        return new ArrayList<MembraneChannel>(this.membraneChannels);
    }

    public double getMembranePotential() {
        if (this.isPlayback()) {
            return this.neuronModelPlaybackState.getMembranePotential();
        }
        return this.hodgkinHuxleyModel.getMembraneVoltage();
    }

    public IHodgkinHuxleyModel getHodgkinHuxleyModel() {
        return this.hodgkinHuxleyModel;
    }

    public double getSodiumInteriorConcentration() {
        if (this.isPlayback()) {
            return this.neuronModelPlaybackState.getSodiumInteriorConcentration();
        }
        return this.sodiumInteriorConcentration;
    }

    public double getSodiumExteriorConcentration() {
        if (this.isPlayback()) {
            return this.neuronModelPlaybackState.getSodiumExteriorConcentration();
        }
        return this.sodiumExteriorConcentration;
    }

    public double getPotassiumInteriorConcentration() {
        if (this.isPlayback()) {
            return this.neuronModelPlaybackState.getPotassiumInteriorConcentration();
        }
        return this.potassiumInteriorConcentration;
    }

    public double getPotassiumExteriorConcentration() {
        if (this.isPlayback()) {
            return this.neuronModelPlaybackState.getPotassiumExteriorConcentration();
        }
        return this.potassiumExteriorConcentration;
    }

    public boolean isPotentialChartVisible() {
        return this.potentialChartVisible;
    }

    public void setPotentialChartVisible(boolean bl) {
        if (this.potentialChartVisible != bl) {
            this.potentialChartVisible = bl;
            this.notifyPotentialChartVisibilityChanged();
        }
    }

    public boolean isConcentrationReadoutVisible() {
        return this.concentrationReadoutVisible;
    }

    public void setConcentrationReadoutVisible(boolean bl) {
        if (this.concentrationReadoutVisible != bl) {
            this.concentrationReadoutVisible = bl;
            this.notifyConcentrationReadoutVisibilityChanged();
        }
    }

    public boolean isChargesShown() {
        return this.chargesShown;
    }

    public void setChargesShown(boolean bl) {
        if (this.chargesShown != bl) {
            this.chargesShown = bl;
            this.notifyChargesShownChanged();
        }
    }

    public boolean isAllIonsSimulated() {
        return this.allIonsSimulated;
    }

    public void setAllIonsSimulated(boolean bl) {
        if (!this.isStimulusInitiationLockedOut() && this.allIonsSimulated != bl) {
            this.allIonsSimulated = bl;
            this.notifyAllIonsSimulatedChanged();
            if (this.allIonsSimulated) {
                this.addInitialBulkParticles();
            } else {
                this.removeAllParticles();
            }
        }
    }

    public void reset() {
        super.resetAll();
        this.axonMembrane.reset();
        this.removeAllParticles();
        this.allIonsSimulated = false;
        for (MembraneChannel membraneChannel : this.membraneChannels) {
            membraneChannel.reset();
        }
        this.hodgkinHuxleyModel.reset();
        boolean bl = false;
        if (this.sodiumExteriorConcentration != 145.0) {
            this.sodiumExteriorConcentration = 145.0;
            bl = true;
        }
        if (this.sodiumInteriorConcentration != 10.0) {
            this.sodiumInteriorConcentration = 10.0;
            bl = true;
        }
        if (this.potassiumExteriorConcentration != 4.0) {
            this.potassiumExteriorConcentration = 4.0;
            bl = true;
        }
        if (this.potassiumInteriorConcentration != 140.0) {
            this.potassiumInteriorConcentration = 140.0;
            bl = true;
        }
        if (bl) {
            this.notifyConcentrationChanged();
        }
        this.setStimulasLockout(false);
        this.setPotentialChartVisible(false);
        this.setConcentrationReadoutVisible(false);
        this.setChargesShown(false);
        this.setAllIonsSimulated(true);
        this.clearHistory();
        this.setModeLive();
        this.setPaused(false);
    }

    public void addBackgroundParticles(ParticleType particleType, ParticlePosition particlePosition, int n) {
        Particle particle = null;
        for (int i = 0; i < n; ++i) {
            particle = this.createBackgroundParticle(particleType);
            if (particlePosition == ParticlePosition.INSIDE_MEMBRANE) {
                this.positionParticleInsideMembrane(particle);
            } else {
                this.positionParticleOutsideMembrane(particle);
            }
            if (RAND.nextBoolean()) {
                particle.setOpaqueness(0.2);
                continue;
            }
            particle.setOpaqueness(0.05);
        }
    }

    public void addBackgroundParticles(ParticleType particleType, CaptureZone captureZone, int n) {
        Particle particle = null;
        for (int i = 0; i < n; ++i) {
            particle = this.createBackgroundParticle(particleType);
            particle.setOpaqueness(0.2);
            Point2D point2D = captureZone.getSuggestedNewParticleLocation();
            particle.setPosition(point2D);
        }
    }

    public void initiateStimulusPulse() {
        if (!this.isStimulusInitiationLockedOut()) {
            this.axonMembrane.initiateTravelingActionPotential();
            this.notifyStimulusPulseInitiated();
            this.updateStimulasLockoutState();
        }
    }

    private void updateStimulasLockoutState() {
        if (this.stimulasLockout) {
            if (!this.isPlayback() && !this.isActionPotentialInProgress()) {
                this.setStimulasLockout(false);
            }
        } else if (this.isActionPotentialInProgress() || this.isPlayback() && this.getTime() < this.getMaxRecordedTime()) {
            this.setStimulasLockout(true);
        }
    }

    private void setStimulasLockout(boolean bl) {
        if (bl != this.stimulasLockout) {
            this.stimulasLockout = bl;
            this.notifyStimulusLockoutStateChanged();
        }
    }

    private void updateSimAndPlaybackParticleVisibility() {
        if (this.isRecord() || this.isLive()) {
            if (this.playbackParticlesVisible) {
                ArrayList<PlaybackParticle> arrayList = new ArrayList<PlaybackParticle>(this.playbackParticles);
                for (PlaybackParticle iViewableParticle : arrayList) {
                    iViewableParticle.removeFromModel();
                }
                this.transientParticles.addAll(this.transientParticlesBackup);
                this.transientParticlesBackup.clear();
                for (Particle particle : this.transientParticles) {
                    this.notifyParticleAdded(particle);
                }
                this.playbackParticlesVisible = false;
            }
        } else if (this.isPlayback()) {
            if (!this.playbackParticlesVisible) {
                this.transientParticlesBackup.addAll(this.transientParticles);
                for (Particle particle : this.transientParticlesBackup) {
                    particle.removeFromModel();
                }
                this.playbackParticlesVisible = true;
            }
        } else {
            System.out.println(this.getClass().getName() + " - Error: Unrecognized record-and-playback mode.");
            assert (false);
        }
    }

    public boolean isStimulusInitiationLockedOut() {
        return this.stimulasLockout;
    }

    public boolean isActionPotentialInProgress() {
        return this.axonMembrane.getTravelingActionPotential() != null || Math.abs(this.hodgkinHuxleyModel.get_k_current()) > 0.001 || Math.abs(this.hodgkinHuxleyModel.get_na_current()) > 0.001 || Math.abs(this.hodgkinHuxleyModel.get_l_current()) > 0.444;
    }

    private Particle createTransientParticle(ParticleType particleType, CaptureZone captureZone) {
        final Particle particle = Particle.createParticle(particleType);
        this.transientParticles.add(particle);
        if (captureZone != null) {
            Point2D point2D = captureZone.getSuggestedNewParticleLocation();
            particle.setPosition(point2D);
        }
        particle.addListener(new ParticleListenerAdapter(){

            public void removedFromModel() {
                NeuronModel.this.transientParticles.remove(particle);
            }
        });
        this.notifyParticleAdded(particle);
        return particle;
    }

    private Particle createBackgroundParticle(ParticleType particleType) {
        final Particle particle = Particle.createParticle(particleType);
        this.backgroundParticles.add(particle);
        particle.addListener(new ParticleListenerAdapter(){

            public void removedFromModel() {
                NeuronModel.this.backgroundParticles.remove(particle);
            }
        });
        this.notifyParticleAdded(particle);
        return particle;
    }

    @Override
    public void requestParticleThroughChannel(ParticleType particleType, MembraneChannel membraneChannel, double d, MembraneCrossingDirection membraneCrossingDirection) {
        CaptureZone captureZone = membraneCrossingDirection == MembraneCrossingDirection.IN_TO_OUT ? membraneChannel.getInteriorCaptureZone() : membraneChannel.getExteriorCaptureZone();
        Particle particle = this.createTransientParticle(particleType, captureZone);
        particle.setFadeStrategy(new TimedFadeInStrategy(5.0E-4));
        membraneChannel.moveParticleThroughNeuronMembrane(particle, d);
    }

    private NeuronModelState getState() {
        return new NeuronModelState(this);
    }

    private CaptureZoneScanResult scanCaptureZoneForFreeParticles(CaptureZone captureZone, ParticleType particleType) {
        Particle particle = null;
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        Point2D point2D = captureZone.getOriginPoint();
        for (Particle particle2 : this.transientParticles) {
            if (particle2.getType() != particleType || !particle2.isAvailableForCapture() || !captureZone.isPointInZone(particle2.getPositionReference())) continue;
            ++n;
            if (particle == null) {
                particle = particle2;
                d = point2D.distance(particle.getPositionReference());
                continue;
            }
            if (!(point2D.distance(particle.getPosition()) < d)) continue;
            particle = particle2;
            d = point2D.distance(particle.getPositionReference());
        }
        return new CaptureZoneScanResult(particle, n);
    }

    private double calculatePlaybackSpeed() {
        double d = this.getClock().getDt() / 4.88888888888889E-5;
        return d;
    }

    public void addListener(Listener listener) {
        this.listeners.add(Listener.class, listener);
    }

    private void notifyChannelAdded(MembraneChannel membraneChannel) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.channelAdded(membraneChannel);
        }
    }

    private void notifyParticleAdded(IViewableParticle iViewableParticle) {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.particleAdded(iViewableParticle);
        }
    }

    private void notifyStimulusPulseInitiated() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.stimulusPulseInitiated();
        }
    }

    private void notifyMembranePotentialChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.membranePotentialChanged();
        }
    }

    private void notifyConcentrationReadoutVisibilityChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.concentrationReadoutVisibilityChanged();
        }
    }

    private void notifyPotentialChartVisibilityChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.potentialChartVisibilityChanged();
        }
    }

    private void notifyChargesShownChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.chargesShownChanged();
        }
    }

    private void notifyAllIonsSimulatedChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.allIonsSimulatedChanged();
        }
    }

    private void notifyStimulusLockoutStateChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.stimulationLockoutStateChanged();
        }
    }

    private void notifyConcentrationChanged() {
        for (Listener listener : (Listener[])this.listeners.getListeners(Listener.class)) {
            listener.concentrationChanged();
        }
    }

    private void addInitialChannels() {
        double d = 1.413716694115407;
        double d2 = 50.0;
        double d3 = Math.PI * 2 / d2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.addChannel(MembraneChannelTypes.SODIUM_LEAKAGE_CHANNEL, d);
        ++n3;
        this.addChannel(MembraneChannelTypes.POTASSIUM_GATED_CHANNEL, d += d3);
        ++n2;
        this.addChannel(MembraneChannelTypes.SODIUM_GATED_CHANNEL, d += d3);
        ++n;
        this.addChannel(MembraneChannelTypes.POTASSIUM_LEAKAGE_CHANNEL, d += d3);
        ++n4;
        d += d3;
        int n5 = 0;
        while ((double)n5 < d2 - 4.0) {
            double d4 = 20.0 / (double)n;
            double d5 = 20.0 / (double)n2;
            double d6 = 7.0 / (double)n4;
            double d7 = 3.0 / (double)n3;
            MembraneChannelTypes membraneChannelTypes = null;
            if (d4 >= d5 && d4 >= d6 && d4 >= d7) {
                membraneChannelTypes = MembraneChannelTypes.SODIUM_GATED_CHANNEL;
                ++n;
            } else if (d5 > d4 && d5 >= d6 && d5 >= d7) {
                membraneChannelTypes = MembraneChannelTypes.POTASSIUM_GATED_CHANNEL;
                ++n2;
            } else if (d6 > d4 && d6 > d5 && d6 >= d7) {
                membraneChannelTypes = MembraneChannelTypes.POTASSIUM_LEAKAGE_CHANNEL;
                ++n4;
            } else if (d7 > d4 && d7 > d5 && d7 > d6) {
                membraneChannelTypes = MembraneChannelTypes.SODIUM_LEAKAGE_CHANNEL;
                ++n3;
            } else assert (false);
            this.addChannel(membraneChannelTypes, d);
            d += d3;
            ++n5;
        }
    }

    private void addChannel(MembraneChannelTypes membraneChannelTypes, double d) {
        MembraneChannel membraneChannel = MembraneChannel.createMembraneChannel(membraneChannelTypes, this, this.hodgkinHuxleyModel);
        double d2 = this.axonMembrane.getCrossSectionDiameter() / 2.0;
        Point2D.Double double_ = new Point2D.Double(d2 * Math.cos(d), d2 * Math.sin(d));
        membraneChannel.setRotationalAngle(d);
        membraneChannel.setCenterLocation(double_);
        this.membraneChannels.add(membraneChannel);
        this.notifyChannelAdded(membraneChannel);
    }

    private void positionParticleInsideMembrane(Particle particle) {
        double d = RAND.nextDouble() * Math.PI * 2.0;
        double d2 = Math.max(RAND.nextDouble(), RAND.nextDouble());
        double d3 = (this.crossSectionInnerRadius - particle.getRadius() * 2.0) * d2;
        particle.setPosition(d3 * Math.cos(d), d3 * Math.sin(d));
    }

    private void positionParticleOutsideMembrane(Particle particle) {
        double d = RAND.nextDouble() * Math.PI * 2.0;
        double d2 = RAND.nextDouble();
        double d3 = this.crossSectionOuterRadius + particle.getRadius() * 4.0 + d2 * this.crossSectionOuterRadius * 2.2;
        particle.setPosition(d3 * Math.cos(d), d3 * Math.sin(d));
    }

    private void addInitialBulkParticles() {
        ArrayList<Particle> arrayList = new ArrayList<Particle>(this.transientParticles);
        this.addBackgroundParticles(ParticleType.SODIUM_ION, ParticlePosition.INSIDE_MEMBRANE, 8);
        this.addBackgroundParticles(ParticleType.SODIUM_ION, ParticlePosition.OUTSIDE_MEMBRANE, 600);
        this.addBackgroundParticles(ParticleType.POTASSIUM_ION, ParticlePosition.INSIDE_MEMBRANE, 200);
        this.addBackgroundParticles(ParticleType.POTASSIUM_ION, ParticlePosition.OUTSIDE_MEMBRANE, 60);
        for (MembraneChannel object : this.membraneChannels) {
            if (!(object instanceof SodiumDualGatedChannel)) continue;
            CaptureZone captureZone = object.getExteriorCaptureZone();
            CaptureZoneScanResult captureZoneScanResult = this.scanCaptureZoneForFreeParticles(captureZone, ParticleType.SODIUM_ION);
            if (captureZoneScanResult.numParticlesInZone != 0) continue;
            this.addBackgroundParticles(ParticleType.SODIUM_ION, captureZone, RAND.nextInt(2) + 1);
        }
        for (Particle particle : this.backgroundParticles) {
            if (arrayList.contains(particle)) continue;
            particle.setMotionStrategy(new SlowBrownianMotionStrategy(particle.getPositionReference()));
        }
    }

    private void removeAllParticles() {
        ArrayList<Particle> arrayList = new ArrayList<Particle>(this.transientParticles);
        for (Particle object2 : arrayList) {
            object2.removeFromModel();
        }
        ArrayList<Particle> arrayList2 = new ArrayList<Particle>(this.backgroundParticles);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Particle particle = (Particle)iterator.next();
            particle.removeFromModel();
        }
    }

    @Override
    public void setPlaybackState(NeuronModelState neuronModelState) {
        Object object;
        this.axonMembrane.setState(neuronModelState.getAxonMembraneState());
        for (MembraneChannel membraneChannel : this.getMembraneChannels()) {
            object = neuronModelState.getMembraneChannelStateMap().get(membraneChannel);
            if (object == null) {
                System.out.println(this.getClass().getName() + " Error: No state found for membrane channel.");
                assert (false);
                continue;
            }
            membraneChannel.setState((MembraneChannel.MembraneChannelState)object);
        }
        int n = neuronModelState.getPlaybackParticleMementos().size() - this.playbackParticles.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                object = new PlaybackParticle();
                this.playbackParticles.add((PlaybackParticle)object);
                ((PlaybackParticle)object).addListener(new ParticleListenerAdapter((PlaybackParticle)object){
                    final /* synthetic */ PlaybackParticle val$newPlaybackParticle;
                    {
                        this.val$newPlaybackParticle = playbackParticle;
                    }

                    public void removedFromModel() {
                        NeuronModel.this.playbackParticles.remove(this.val$newPlaybackParticle);
                    }
                });
                this.notifyParticleAdded((IViewableParticle)object);
            }
        } else if (n < 0) {
            for (int i = n; i < 0; ++i) {
                this.playbackParticles.get(this.playbackParticles.size() - 1).removeFromModel();
            }
        }
        int n2 = 0;
        for (ParticlePlaybackMemento particlePlaybackMemento : neuronModelState.getPlaybackParticleMementos()) {
            this.playbackParticles.get(n2).restoreFromMemento(particlePlaybackMemento);
            ++n2;
        }
        object = this.neuronModelPlaybackState;
        this.neuronModelPlaybackState = neuronModelState;
        if (object == null || ((NeuronModelState)object).getMembranePotential() != neuronModelState.getMembranePotential()) {
            this.notifyMembranePotentialChanged();
        }
        this.notifyConcentrationChanged();
    }

    @Override
    public void stepInTime(double d) {
        if (d < 0.0 && this.getPlaybackSpeed() > 0.0) {
            this.setPlayback(-1.0);
            if (this.getTime() > this.getMaxRecordedTime()) {
                this.setTime(this.getMaxRecordedTime());
            }
        } else if (this.getPlaybackSpeed() < 0.0 && d > 0.0 && this.isPlayback()) {
            this.setPlayback(1.0);
        }
        super.stepInTime(d);
        if (this.isPlayback() && this.getTime() >= this.getMaxRecordedTime()) {
            this.setModeRecord();
            this.setPaused(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NeuronModelState step(double d) {
        void var4_14;
        double d2;
        this.axonMembrane.stepInTime(d);
        this.hodgkinHuxleyModel.stepInTime(d);
        if (Math.abs(this.previousMembranePotential - this.hodgkinHuxleyModel.getMembraneVoltage()) > 0.005) {
            this.previousMembranePotential = this.hodgkinHuxleyModel.getMembraneVoltage();
            this.notifyMembranePotentialChanged();
        }
        this.updateStimulasLockoutState();
        for (MembraneChannel iterator2 : this.membraneChannels) {
            iterator2.stepInTime(d);
        }
        ArrayList<Particle> arrayList = new ArrayList<Particle>(this.transientParticles);
        Iterator bl = arrayList.iterator();
        while (bl.hasNext()) {
            Particle particle = (Particle)bl.next();
            particle.stepInTime(d);
        }
        for (Particle particle : this.backgroundParticles) {
            particle.stepInTime(d);
        }
        boolean bl2 = false;
        double d3 = this.hodgkinHuxleyModel.get_delayed_n4(0.001);
        if (d3 != 0.0) {
            this.potassiumExteriorConcentration += d3 * d * 0.05;
            this.potassiumInteriorConcentration -= d3 * d * 2.0;
            boolean bl3 = true;
        } else {
            if (this.potassiumExteriorConcentration != 4.0) {
                d2 = Math.abs(this.potassiumExteriorConcentration - 4.0);
                this.potassiumExteriorConcentration = d2 < 1.0E-6 ? 4.0 : (this.potassiumExteriorConcentration -= d2 * 1000.0 * d);
                boolean bl4 = true;
            }
            if (this.potassiumInteriorConcentration != 140.0) {
                d2 = Math.abs(this.potassiumInteriorConcentration - 140.0);
                this.potassiumInteriorConcentration = d2 < 1.0E-6 ? 140.0 : (this.potassiumInteriorConcentration += d2 * 1000.0 * d);
                boolean bl5 = true;
            }
        }
        d2 = this.hodgkinHuxleyModel.get_delayed_m3h(0.001);
        if (this.hodgkinHuxleyModel.get_m3h() != 0.0) {
            this.sodiumExteriorConcentration -= d2 * d * 7.0;
            this.sodiumInteriorConcentration += d2 * d * 0.4;
            boolean bl6 = true;
        } else {
            double d4;
            if (this.sodiumExteriorConcentration != 145.0) {
                d4 = Math.abs(this.sodiumExteriorConcentration - 145.0);
                this.sodiumExteriorConcentration = d4 < 1.0E-6 ? 145.0 : (this.sodiumExteriorConcentration += d4 * 1000.0 * d);
                boolean bl7 = true;
            }
            if (this.sodiumInteriorConcentration != 10.0) {
                d4 = Math.abs(this.sodiumInteriorConcentration - 10.0);
                this.sodiumInteriorConcentration = d4 < 1.0E-6 ? 10.0 : (this.sodiumInteriorConcentration -= d4 * 1000.0 * d);
                boolean bl8 = true;
            }
        }
        if (var4_14 != false) {
            this.notifyConcentrationChanged();
        }
        return this.getState();
    }

    public static class Adapter
    implements Listener {
        public void channelAdded(MembraneChannel membraneChannel) {
        }

        public void particleAdded(IViewableParticle iViewableParticle) {
        }

        public void stimulusPulseInitiated() {
        }

        public void potentialChartVisibilityChanged() {
        }

        public void stimulationLockoutStateChanged() {
        }

        public void allIonsSimulatedChanged() {
        }

        public void chargesShownChanged() {
        }

        public void membranePotentialChanged() {
        }

        public void concentrationChanged() {
        }

        public void concentrationReadoutVisibilityChanged() {
        }
    }

    public static class CaptureZoneScanResult {
        final Particle closestFreeParticle;
        final int numParticlesInZone;

        public CaptureZoneScanResult(Particle particle, int n) {
            this.closestFreeParticle = particle;
            this.numParticlesInZone = n;
        }
    }

    public static interface Listener
    extends EventListener {
        public void channelAdded(MembraneChannel var1);

        public void particleAdded(IViewableParticle var1);

        public void stimulusPulseInitiated();

        public void membranePotentialChanged();

        public void potentialChartVisibilityChanged();

        public void concentrationReadoutVisibilityChanged();

        public void chargesShownChanged();

        public void allIonsSimulatedChanged();

        public void stimulationLockoutStateChanged();

        public void concentrationChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NeuronModelState {
        private final AxonMembrane.AxonMembraneState axonMembraneState;
        private final HashMap<MembraneChannel, MembraneChannel.MembraneChannelState> membraneChannelStateMap = new HashMap();
        private final ArrayList<ParticlePlaybackMemento> particlePlaybackMementos = new ArrayList();
        private final double membranePotential;
        private final double sodiumInteriorConcentration;
        private final double sodiumExteriorConcentration;
        private final double potassiumInteriorConcentration;
        private final double potassiumExteriorConcentration;

        public NeuronModelState(NeuronModel neuronModel) {
            this.axonMembraneState = neuronModel.getAxonMembrane().getState();
            this.membranePotential = neuronModel.getMembranePotential();
            this.sodiumExteriorConcentration = neuronModel.getSodiumExteriorConcentration();
            this.sodiumInteriorConcentration = neuronModel.getSodiumInteriorConcentration();
            this.potassiumExteriorConcentration = neuronModel.getPotassiumExteriorConcentration();
            this.potassiumInteriorConcentration = neuronModel.getPotassiumInteriorConcentration();
            for (MembraneChannel object : neuronModel.getMembraneChannels()) {
                this.membraneChannelStateMap.put(object, object.getState());
            }
            for (Particle particle : neuronModel.getParticles()) {
                this.particlePlaybackMementos.add(particle.getPlaybackMemento());
            }
        }

        protected AxonMembrane.AxonMembraneState getAxonMembraneState() {
            return this.axonMembraneState;
        }

        protected HashMap<MembraneChannel, MembraneChannel.MembraneChannelState> getMembraneChannelStateMap() {
            return this.membraneChannelStateMap;
        }

        protected ArrayList<ParticlePlaybackMemento> getPlaybackParticleMementos() {
            return this.particlePlaybackMementos;
        }

        protected double getMembranePotential() {
            return this.membranePotential;
        }

        protected double getSodiumInteriorConcentration() {
            return this.sodiumInteriorConcentration;
        }

        protected double getSodiumExteriorConcentration() {
            return this.sodiumExteriorConcentration;
        }

        protected double getPotassiumInteriorConcentration() {
            return this.potassiumInteriorConcentration;
        }

        protected double getPotassiumExteriorConcentration() {
            return this.potassiumExteriorConcentration;
        }
    }
}

