/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.FadeStrategy;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.IParticleListener;
import edu.colorado.phet.neuron.model.IViewableParticle;
import edu.colorado.phet.neuron.model.MembraneTraversalMotionStrategy;
import edu.colorado.phet.neuron.model.MotionStrategy;
import edu.colorado.phet.neuron.model.NullFadeStrategy;
import edu.colorado.phet.neuron.model.ParticlePlaybackMemento;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PotassiumIon;
import edu.colorado.phet.neuron.model.SodiumIon;
import edu.colorado.phet.neuron.model.StillnessMotionStrategy;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class Particle
implements IFadable,
IMovable,
IViewableParticle {
    protected ArrayList<IParticleListener> listeners = new ArrayList();
    private Point2D.Double position;
    private MotionStrategy motionStrategy = new StillnessMotionStrategy();
    private double opaqueness = 1.0;
    private FadeStrategy fadeStrategy = new NullFadeStrategy();

    public Particle(double d, double d2) {
        this.position = new Point2D.Double(d, d2);
    }

    public Particle() {
        this(0.0, 0.0);
    }

    public static Particle createParticle(ParticleType particleType) {
        Particle particle = null;
        switch (particleType) {
            case POTASSIUM_ION: {
                particle = new PotassiumIon();
                break;
            }
            case SODIUM_ION: {
                particle = new SodiumIon();
                break;
            }
            default: {
                System.err.println("Error: Unrecognized particle type.");
                assert (false);
                break;
            }
        }
        return particle;
    }

    public abstract ParticleType getType();

    public Point2D getPosition() {
        return new Point2D.Double(this.position.getX(), this.position.getY());
    }

    public Point2D.Double getPositionReference() {
        return this.position;
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
        this.notifyPositionChanged();
    }

    public void setOpaqueness(double d) {
        if (this.opaqueness != d) {
            this.opaqueness = d;
            this.notifyAppearanceChanged();
        }
    }

    public double getOpaqueness() {
        return this.opaqueness;
    }

    public void setFadeStrategy(FadeStrategy fadeStrategy) {
        this.fadeStrategy = fadeStrategy;
    }

    protected boolean isAvailableForCapture() {
        return !(this.motionStrategy instanceof MembraneTraversalMotionStrategy);
    }

    public ParticlePlaybackMemento getPlaybackMemento() {
        return new ParticlePlaybackMemento(this);
    }

    protected void notifyPositionChanged() {
        for (IParticleListener iParticleListener : this.listeners) {
            iParticleListener.positionChanged();
        }
    }

    protected void notifyAppearanceChanged() {
        for (IParticleListener iParticleListener : this.listeners) {
            iParticleListener.appearanceChanged();
        }
    }

    public void removeFromModel() {
        this.notifyRemoved();
    }

    private void notifyRemoved() {
        ArrayList<IParticleListener> arrayList = new ArrayList<IParticleListener>(this.listeners);
        for (IParticleListener iParticleListener : arrayList) {
            iParticleListener.removedFromModel();
        }
    }

    public void setMotionStrategy(MotionStrategy motionStrategy) {
        this.motionStrategy = motionStrategy;
    }

    public double getRadius() {
        return 0.75;
    }

    public abstract Color getRepresentationColor();

    public void stepInTime(double d) {
        this.motionStrategy.move(this, this, d);
        this.fadeStrategy.updateOpaqueness(this, d);
        if (!this.fadeStrategy.shouldContinueExisting(this)) {
            this.notifyRemoved();
        }
    }

    public void addListener(IParticleListener iParticleListener) {
        if (this.listeners.contains(iParticleListener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(iParticleListener);
    }
}

