/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.IParticleListener;
import edu.colorado.phet.neuron.model.IViewableParticle;
import edu.colorado.phet.neuron.model.Particle;
import edu.colorado.phet.neuron.model.ParticlePlaybackMemento;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PotassiumIon;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PlaybackParticle
implements IViewableParticle {
    private final Point2D position = new Point2D.Double();
    private Color representationColor;
    private double opaqueness;
    private final double radius;
    private ParticleType particleType;
    protected ArrayList<IParticleListener> listeners = new ArrayList();

    public PlaybackParticle(Particle particle) {
        this.position.setLocation(particle.getPosition());
        this.opaqueness = particle.getOpaqueness();
        this.representationColor = particle.getRepresentationColor();
        this.radius = particle.getRadius();
        this.particleType = particle.getType();
    }

    public PlaybackParticle() {
        this(new PotassiumIon());
    }

    public void restoreFromMemento(ParticlePlaybackMemento particlePlaybackMemento) {
        this.setPosition(particlePlaybackMemento.getPositionRef());
        boolean bl = false;
        if (this.opaqueness != particlePlaybackMemento.getOpaqueness()) {
            this.opaqueness = particlePlaybackMemento.getOpaqueness();
            bl = true;
        }
        if (this.particleType != particlePlaybackMemento.getParticleType()) {
            this.particleType = particlePlaybackMemento.getParticleType();
            bl = true;
        }
        if (this.representationColor != particlePlaybackMemento.getRepresentationColor()) {
            this.representationColor = particlePlaybackMemento.getRepresentationColor();
            bl = true;
        }
        if (bl) {
            this.notifyAppearanceChanged();
        }
    }

    public void removeFromModel() {
        this.notifyRemoved();
        this.listeners.clear();
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.position.getX(), this.position.getY());
    }

    private void setPosition(Point2D point2D) {
        if (this.position.getX() != point2D.getX() || this.position.getY() != point2D.getY()) {
            this.position.setLocation(point2D);
            this.notifyPositionChanged();
        }
    }

    public Color getRepresentationColor() {
        return this.representationColor;
    }

    public double getOpaqueness() {
        return this.opaqueness;
    }

    public double getRadius() {
        return this.radius;
    }

    public ParticleType getType() {
        return this.particleType;
    }

    public void addListener(IParticleListener iParticleListener) {
        if (this.listeners.contains(iParticleListener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(iParticleListener);
    }

    private void notifyRemoved() {
        ArrayList<IParticleListener> arrayList = new ArrayList<IParticleListener>(this.listeners);
        for (IParticleListener iParticleListener : arrayList) {
            iParticleListener.removedFromModel();
        }
    }

    protected void notifyPositionChanged() {
        for (IParticleListener iParticleListener : this.listeners) {
            iParticleListener.positionChanged();
        }
    }

    protected void notifyAppearanceChanged() {
        for (IParticleListener iParticleListener : this.listeners) {
            iParticleListener.appearanceChanged();
        }
    }
}

