/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.MotionStrategy;
import java.awt.geom.Point2D;
import java.util.Random;

public class SlowBrownianMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private final Point2D initialLocation = new Point2D.Double();
    private double timeUntilNextJump;

    public SlowBrownianMotionStrategy(Point2D point2D) {
        this.initialLocation.setLocation(point2D);
        this.timeUntilNextJump = this.generateNewJumpTime();
    }

    public void move(IMovable iMovable, IFadable iFadable, double d) {
        this.timeUntilNextJump -= d;
        if (this.timeUntilNextJump <= 0.0) {
            if (iMovable.getPosition().equals(this.initialLocation)) {
                double d2 = this.generateNewJumpAngle();
                double d3 = this.generateNewJumpDistance();
                Point2D point2D = iMovable.getPositionReference();
                iMovable.setPosition(point2D.getX() + d3 * Math.cos(d2), point2D.getY() + d3 * Math.sin(d2));
            } else {
                iMovable.setPosition(this.initialLocation);
            }
            this.timeUntilNextJump = this.generateNewJumpTime();
        }
    }

    private double generateNewJumpTime() {
        return 9.0E-4 + RAND.nextDouble() * 6.000000000000001E-4;
    }

    private double generateNewJumpDistance() {
        return 0.1 + RAND.nextDouble() * 0.9;
    }

    private double generateNewJumpAngle() {
        return RAND.nextDouble() * Math.PI * 2.0;
    }
}

