/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.model.DualGateChannelTraversalMotionStrategy;
import edu.colorado.phet.neuron.model.GatedChannel;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.Particle;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PieSliceShapedCaptureZone;
import edu.colorado.phet.neuron.utils.MathUtils;
import java.awt.Color;
import java.awt.Dimension;

public class SodiumDualGatedChannel
extends GatedChannel {
    private IHodgkinHuxleyModel hodgkinHuxleyModel;
    private GateState gateState = GateState.IDLE;
    private double previousNormalizedConductance;
    private double stateTransitionTimer = 0.0;
    private double staggerDelay;
    private static final Dimension INITIAL_INTERMEDIATE_DIMENSION = new Dimension(786, 786);

    public SodiumDualGatedChannel(IParticleCapture iParticleCapture, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(2.0, 4.8, iParticleCapture);
        this.hodgkinHuxleyModel = iHodgkinHuxleyModel;
        this.setExteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, 0.0, 2.199114857512855));
        this.reset();
    }

    public SodiumDualGatedChannel() {
        this(null, null);
    }

    public Color getChannelColor() {
        return ColorUtils.darkerColor(NeuronConstants.SODIUM_COLOR, 0.2);
    }

    public Color getEdgeColor() {
        return NeuronConstants.SODIUM_COLOR;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        double d2 = this.calculateNormalizedConductance();
        if (d2 >= 0.0 && d2 <= 1.0) {
            d2 = MathUtils.round(d2, 4);
        } else {
            System.err.println(this.getClass().getName() + "Nomalized conductance out of range, = " + d2);
            assert (false);
        }
        switch (this.gateState) {
            case IDLE: {
                if (!(d2 > 0.002)) break;
                this.setOpenness(this.mapOpennessToNormalizedConductance(d2));
                this.gateState = GateState.OPENING;
                break;
            }
            case OPENING: {
                if (this.isOpen() && this.getCaptureCountdownTimer() == Double.POSITIVE_INFINITY) {
                    this.restartCaptureCountdownTimer(true);
                }
                if (this.previousNormalizedConductance > d2) {
                    this.gateState = GateState.BECOMING_INACTIVE;
                    this.setOpenness(1.0);
                    break;
                }
                this.setOpenness(this.mapOpennessToNormalizedConductance(d2));
                break;
            }
            case BECOMING_INACTIVE: {
                if (this.getInactivationAmt() < 0.98) {
                    this.setInactivationAmt(1.0 - Math.pow(d2, 7.0));
                    break;
                }
                this.setInactivationAmt(1.0);
                this.gateState = GateState.INACTIVATED;
                this.stateTransitionTimer = 0.001;
                break;
            }
            case INACTIVATED: {
                this.stateTransitionTimer -= d;
                if (!(this.stateTransitionTimer < 0.0)) break;
                this.gateState = GateState.RESETTING;
                this.stateTransitionTimer = 0.001;
                break;
            }
            case RESETTING: {
                this.stateTransitionTimer -= d;
                if (this.stateTransitionTimer >= 0.0) {
                    this.setOpenness(1.0 - Math.pow(this.stateTransitionTimer / 0.001 - 1.0, 10.0));
                    this.setInactivationAmt(1.0 - Math.pow(this.stateTransitionTimer / 0.001 - 1.0, 20.0));
                    break;
                }
                this.setOpenness(0.0);
                this.setInactivationAmt(0.0);
                this.updateStaggerDelay();
                this.gateState = GateState.IDLE;
            }
        }
        this.previousNormalizedConductance = d2;
    }

    public void moveParticleThroughNeuronMembrane(Particle particle, double d) {
        particle.setMotionStrategy(new DualGateChannelTraversalMotionStrategy(this, particle.getPositionReference()));
    }

    private double mapOpennessToNormalizedConductance(double d) {
        assert (d >= 0.0 && d <= 1.0);
        return 1.0 - Math.pow(d - 1.0, 20.0);
    }

    public boolean getHasInactivationGate() {
        return true;
    }

    private double calculateNormalizedConductance() {
        return Math.min(Math.abs(this.hodgkinHuxleyModel.get_delayed_m3h(this.staggerDelay)) / 0.25, 1.0);
    }

    protected ParticleType getParticleTypeToCapture() {
        return ParticleType.SODIUM_ION;
    }

    public void reset() {
        super.reset();
        this.setMinInterCaptureTime(2.0E-5);
        this.setMaxInterCaptureTime(1.0E-4);
        this.gateState = GateState.IDLE;
        this.stateTransitionTimer = 0.0;
        if (this.hodgkinHuxleyModel != null) {
            this.previousNormalizedConductance = this.calculateNormalizedConductance();
        }
        this.updateStaggerDelay();
    }

    private void updateStaggerDelay() {
        this.staggerDelay = RAND.nextDouble() * 1.1111111111111112E-4;
    }

    protected MembraneCrossingDirection chooseCrossingDirection() {
        return MembraneCrossingDirection.OUT_TO_IN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GateState
    extends Enum<GateState> {
        public static final /* enum */ GateState IDLE = new GateState();
        public static final /* enum */ GateState OPENING = new GateState();
        public static final /* enum */ GateState BECOMING_INACTIVE = new GateState();
        public static final /* enum */ GateState INACTIVATED = new GateState();
        public static final /* enum */ GateState RESETTING = new GateState();
        private static final /* synthetic */ GateState[] $VALUES;

        public static GateState[] values() {
            return (GateState[])$VALUES.clone();
        }

        static {
            $VALUES = new GateState[]{IDLE, OPENING, BECOMING_INACTIVE, INACTIVATED, RESETTING};
        }
    }
}

