/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.FadeStrategy;
import edu.colorado.phet.neuron.model.IFadable;

public class TimedFadeAwayStrategy
extends FadeStrategy {
    public final double fadeTime;
    public double fadeCountdownTimer;

    public TimedFadeAwayStrategy(double d) {
        this.fadeTime = d;
        this.fadeCountdownTimer = d;
    }

    public void updateOpaqueness(IFadable iFadable, double d) {
        iFadable.setOpaqueness(Math.min(Math.max(this.fadeCountdownTimer / this.fadeTime, 0.0), iFadable.getOpaqueness()));
        this.fadeCountdownTimer -= d;
    }

    public boolean shouldContinueExisting(IFadable iFadable) {
        return iFadable.getOpaqueness() > 0.0;
    }
}

