/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.FadeStrategy;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.NullFadeStrategy;

public class TimedFadeInStrategy
extends FadeStrategy {
    public final double fadeTime;
    public double opaquenessTarget = 1.0;
    public double fadeCountdownTimer;

    public TimedFadeInStrategy(double d) {
        this.fadeTime = d;
        this.fadeCountdownTimer = d;
    }

    public void updateOpaqueness(IFadable iFadable, double d) {
        iFadable.setOpaqueness(Math.min((1.0 - this.fadeCountdownTimer / this.fadeTime) * this.opaquenessTarget, 1.0));
        this.fadeCountdownTimer -= d;
        if (this.fadeCountdownTimer < 0.0) {
            this.fadeCountdownTimer = 0.0;
            iFadable.setFadeStrategy(new NullFadeStrategy());
        }
    }
}

