/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.MembraneChannel;
import edu.colorado.phet.neuron.model.MembraneTraversalMotionStrategy;
import edu.colorado.phet.neuron.model.TimedFadeAwayStrategy;
import edu.colorado.phet.neuron.model.WanderAwayThenFadeMotionStrategy;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraverseChannelAndFadeMotionStrategy
extends MembraneTraversalMotionStrategy {
    private static final Random RAND = new Random();
    private Vector2D velocityVector = new Vector2D();
    private ArrayList<Point2D> traversalPoints;
    private int currentDestinationIndex = 0;
    private boolean channelHasBeenEntered = false;
    private double maxVelocity;
    protected final MembraneChannel channel;

    public TraverseChannelAndFadeMotionStrategy(MembraneChannel membraneChannel, Point2D point2D, double d) {
        this.channel = membraneChannel;
        this.maxVelocity = d;
        this.traversalPoints = this.createTraversalPoints(membraneChannel, point2D);
        this.currentDestinationIndex = 0;
        this.setCourseForCurrentTraversalPoint(point2D);
    }

    @Override
    public void move(IMovable iMovable, IFadable iFadable, double d) {
        Point2D point2D = iMovable.getPositionReference();
        if (!this.channelHasBeenEntered) {
            this.channelHasBeenEntered = this.channel.isPointInChannel(point2D);
        }
        if (this.channel.isOpen() || this.channelHasBeenEntered) {
            if (this.currentDestinationIndex >= this.traversalPoints.size() || this.maxVelocity * d < point2D.distance(this.traversalPoints.get(this.currentDestinationIndex))) {
                iMovable.setPosition(point2D.getX() + this.velocityVector.getX() * d, point2D.getY() + this.velocityVector.getY() * d);
            } else {
                iMovable.setPosition(this.traversalPoints.get(this.currentDestinationIndex));
                ++this.currentDestinationIndex;
                this.setCourseForCurrentTraversalPoint(iMovable.getPosition());
                if (this.currentDestinationIndex == this.traversalPoints.size()) {
                    iFadable.setFadeStrategy(new TimedFadeAwayStrategy(0.002));
                    if (this.maxVelocity / 40000.0 >= 0.5) {
                        this.velocityVector.scale(0.2);
                    }
                }
            }
        } else {
            iMovable.setMotionStrategy(new WanderAwayThenFadeMotionStrategy(this.channel.getCenterLocation(), iMovable.getPosition(), 0.0, 0.002));
        }
    }

    private ArrayList<Point2D> createTraversalPoints(MembraneChannel membraneChannel, Point2D point2D) {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D point2D2 = membraneChannel.getCenterLocation();
        double d = membraneChannel.getChannelSize().getHeight() * 0.65;
        Point2D.Double double_ = new Point2D.Double(point2D2.getX() + Math.cos(membraneChannel.getRotationalAngle()) * d, point2D2.getY() + Math.sin(membraneChannel.getRotationalAngle()) * d);
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX() - Math.cos(membraneChannel.getRotationalAngle()) * d, point2D2.getY() - Math.sin(membraneChannel.getRotationalAngle()) * d);
        if (point2D.distance(double_2) < point2D.distance(double_)) {
            arrayList.add(double_2);
            arrayList.add(double_);
        } else {
            arrayList.add(double_);
            arrayList.add(double_2);
        }
        return arrayList;
    }

    private void setCourseForCurrentTraversalPoint(Point2D point2D) {
        if (this.currentDestinationIndex < this.traversalPoints.size()) {
            Point2D point2D2 = this.traversalPoints.get(this.currentDestinationIndex);
            this.velocityVector.setComponents(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            double d = this.maxVelocity / this.velocityVector.getMagnitude();
            this.velocityVector.scale(d);
        } else {
            this.velocityVector.rotate((RAND.nextDouble() - 0.5) * Math.PI * 0.9);
        }
    }
}

