/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.module;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.clock.SimSpeedControl;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.neuron.NeuronStrings;
import edu.colorado.phet.neuron.controlpanel.AxonCrossSectionControlPanel;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.NeuronClock;
import edu.colorado.phet.neuron.model.NeuronModel;
import edu.colorado.phet.neuron.view.NeuronCanvas;
import java.awt.Frame;

public class NeuronModule
extends PiccoloModule {
    private final NeuronModel model;
    private final NeuronCanvas canvas;
    private final AxonCrossSectionControlPanel controlPanel;
    private final PiccoloClockControlPanel clockControlPanel;

    public NeuronModule(Frame frame) {
        super(NeuronStrings.TITLE_AXON_CROSS_SECTION_MODULE, new NeuronClock(15, 4.88888888888889E-5));
        NeuronClock neuronClock = (NeuronClock)this.getClock();
        this.model = new NeuronModel(neuronClock);
        this.canvas = new NeuronCanvas(this.model);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new AxonCrossSectionControlPanel(this, frame, this.model);
        this.setControlPanel(this.controlPanel);
        this.clockControlPanel = new PiccoloClockControlPanel(this.getClock());
        SimSpeedControl simSpeedControl = new SimSpeedControl(2.2222222222222223E-5, 6.666666666666667E-5, (ConstantDtClock)this.getClock(), PhetCommonResources.getString("Common.sim.speed"));
        this.clockControlPanel.addBetweenTimeDisplayAndButtons(simSpeedControl);
        this.clockControlPanel.setStepBackButtonVisible(true);
        this.setClockControlPanel(this.clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public IHodgkinHuxleyModel getHodgkinHuxleyModel() {
        return this.model.getHodgkinHuxleyModel();
    }

    public void reset() {
        this.model.getClock().resetSimulationTime();
        this.model.reset();
        this.canvas.reset();
        this.setClockRunningWhenActive(true);
    }
}

