/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.model.AxonMembrane;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class AxonCrossSectionNode
extends PNode {
    private static final Color MEMBRANE_COLOR = Color.YELLOW;
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private ModelViewTransform2D mvt;
    private PhetPPath outerMembrane;
    private PhetPPath innerMembrane;

    public AxonCrossSectionNode(AxonMembrane axonMembrane, ModelViewTransform2D modelViewTransform2D) {
        this.mvt = modelViewTransform2D;
        double d = axonMembrane.getCrossSectionDiameter() + axonMembrane.getMembraneThickness();
        double d2 = axonMembrane.getCrossSectionDiameter() - axonMembrane.getMembraneThickness();
        Shape shape = this.mvt.createTransformedShape(new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d));
        Shape shape2 = this.mvt.createTransformedShape(new Ellipse2D.Double(-d2 / 2.0, -d2 / 2.0, d2, d2));
        this.outerMembrane = new PhetPPath(shape, MEMBRANE_COLOR, STROKE, Color.BLACK);
        this.addChild(this.outerMembrane);
        this.innerMembrane = new PhetPPath(shape2, new Color(73, 210, 242), STROKE, Color.BLACK);
        this.addChild(this.innerMembrane);
    }
}

