/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.model.NeuronModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class ChargeSymbolNode
extends PNode {
    private static final Stroke EDGE_STROKE = new BasicStroke(0.75f);
    private static final Color EDGE_COLOR = new Color(255, 102, 0);
    private static final Color FILL_COLOR = Color.WHITE;
    private final NeuronModel axonModel;
    private final double maxPotential;
    private final double maxWidth;
    private final boolean polarityReversed;
    private final PPath representation;

    public ChargeSymbolNode(NeuronModel neuronModel, double d, double d2, boolean bl) {
        this.axonModel = neuronModel;
        this.maxWidth = d;
        this.polarityReversed = bl;
        this.maxPotential = d2;
        neuronModel.addListener(new NeuronModel.Adapter(){

            public void membranePotentialChanged() {
                ChargeSymbolNode.this.updateRepresentation();
            }
        });
        this.representation = new PhetPPath(FILL_COLOR, EDGE_STROKE, (Paint)EDGE_COLOR);
        this.addChild(this.representation);
        this.updateRepresentation();
    }

    private void updateRepresentation() {
        boolean bl;
        double d = this.maxWidth * Math.abs(this.axonModel.getMembranePotential() / this.maxPotential);
        boolean bl2 = bl = this.axonModel.getMembranePotential() > 0.0 && !this.polarityReversed || this.axonModel.getMembranePotential() < 0.0 && this.polarityReversed;
        if (bl) {
            this.representation.setPathTo(this.drawPlusSign(d));
        } else {
            this.representation.setPathTo(this.drawMinusSign(d));
        }
    }

    private Shape drawPlusSign(double d) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d2 = d * 0.4;
        double d3 = d2 / 2.0;
        double d4 = d / 2.0;
        doubleGeneralPath.moveTo(-d4, -d3);
        doubleGeneralPath.lineTo(-d4, d3);
        doubleGeneralPath.lineTo(-d3, d3);
        doubleGeneralPath.lineTo(-d3, d4);
        doubleGeneralPath.lineTo(d3, d4);
        doubleGeneralPath.lineTo(d3, d3);
        doubleGeneralPath.lineTo(d4, d3);
        doubleGeneralPath.lineTo(d4, -d3);
        doubleGeneralPath.lineTo(d3, -d3);
        doubleGeneralPath.lineTo(d3, -d4);
        doubleGeneralPath.lineTo(-d3, -d4);
        doubleGeneralPath.lineTo(-d3, -d3);
        doubleGeneralPath.closePath();
        return doubleGeneralPath.getGeneralPath();
    }

    private Shape drawMinusSign(double d) {
        double d2 = d * 0.4;
        return new Rectangle2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
    }
}

