/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.NeuronStrings;
import edu.colorado.phet.neuron.model.IViewableParticle;
import edu.colorado.phet.neuron.model.MembraneChannel;
import edu.colorado.phet.neuron.model.NeuronModel;
import edu.colorado.phet.neuron.model.Particle;
import edu.colorado.phet.neuron.model.ParticleListenerAdapter;
import edu.colorado.phet.neuron.model.PotassiumIon;
import edu.colorado.phet.neuron.model.SodiumIon;
import edu.colorado.phet.neuron.module.NeuronDefaults;
import edu.colorado.phet.neuron.utils.MathUtils;
import edu.colorado.phet.neuron.view.AxonBodyNode;
import edu.colorado.phet.neuron.view.AxonCrossSectionNode;
import edu.colorado.phet.neuron.view.ChargeSymbolNode;
import edu.colorado.phet.neuron.view.IZoomable;
import edu.colorado.phet.neuron.view.MembraneChannelNode;
import edu.colorado.phet.neuron.view.MembranePotentialChart;
import edu.colorado.phet.neuron.view.ParticleNode;
import edu.colorado.phet.neuron.view.ZoomControl;
import edu.colorado.phet.neuron.view.ZoomListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuronCanvas
extends PhetPCanvas
implements IZoomable {
    private static final Dimension2D POTENTIAL_CHART_SIZE = new PDimension(NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.width * 0.95, NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.height * 0.3);
    private static final Color CANVAS_BUTTON_COLOR = new Color(255, 144, 0);
    private static final DecimalFormat CONCENTRATION_READOUT_FORMATTER = new DecimalFormat("##0.00000");
    private NeuronModel model;
    private ModelViewTransform2D mvt;
    private PNode particleLayer;
    private PNode axonBodyLayer;
    private PNode axonCrossSectionLayer;
    private PNode channelLayer;
    private PNode channelEdgeLayer;
    private PNode chartLayer;
    private PNode concentrationReadoutLayer;
    private PNode chargeSymbolLayer;
    private MembranePotentialChart membranePotentialChart;
    HTMLImageButtonNode stimulateNeuronButton;
    PText sodiumInteriorConcentrationReadout;
    PText sodiumExteriorConcentrationReadout;
    PText potassiumInteriorConcentrationReadout;
    PText potassiumExteriorConcentrationReadout;
    private EventListenerList listeners = new EventListenerList();
    private double zoomFactor = 1.0;
    private PNode myWorldNode;
    private Rectangle2D viewportInIntermediateCoords = new Rectangle2D.Double();
    private AxonCrossSectionNode axonCrossSectionNode;

    public NeuronCanvas(final NeuronModel neuronModel) {
        this.model = neuronModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteringBoxStrategy(this, NeuronDefaults.INTERMEDIATE_RENDERING_SIZE));
        this.mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point((int)Math.round(NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.width * 0.5), (int)Math.round(NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.height * 0.5)), 3.9, true);
        this.model.addListener(new NeuronModel.Adapter(){

            public void channelAdded(MembraneChannel membraneChannel) {
                NeuronCanvas.this.addChannelNode(membraneChannel);
            }

            public void particleAdded(IViewableParticle iViewableParticle) {
                NeuronCanvas.this.addParticle(iViewableParticle);
            }

            public void potentialChartVisibilityChanged() {
                NeuronCanvas.this.membranePotentialChart.setVisible(neuronModel.isPotentialChartVisible());
            }

            public void chargesShownChanged() {
                NeuronCanvas.this.updateChargeSymbolsShown();
            }

            public void stimulationLockoutStateChanged() {
                NeuronCanvas.this.updateStimButtonState();
            }

            public void concentrationReadoutVisibilityChanged() {
                NeuronCanvas.this.updateConcentrationReadoutVisible();
            }

            public void concentrationChanged() {
                NeuronCanvas.this.updateConcentrationReadoutValues();
            }
        });
        this.setBackground(NeuronConstants.CANVAS_BACKGROUND);
        this.myWorldNode = new PNode();
        this.addWorldChild(this.myWorldNode);
        this.axonBodyLayer = new PNode();
        this.axonCrossSectionLayer = new PNode();
        this.particleLayer = new PNode();
        this.channelLayer = new PNode();
        this.channelEdgeLayer = new PNode();
        this.chargeSymbolLayer = new PNode();
        this.myWorldNode.addChild(this.axonBodyLayer);
        this.myWorldNode.addChild(this.axonCrossSectionLayer);
        this.myWorldNode.addChild(this.channelLayer);
        this.myWorldNode.addChild(this.particleLayer);
        this.myWorldNode.addChild(this.channelEdgeLayer);
        this.myWorldNode.addChild(this.chargeSymbolLayer);
        this.concentrationReadoutLayer = new PNode();
        this.chartLayer = new PNode();
        this.addScreenChild(this.concentrationReadoutLayer);
        this.addScreenChild(this.chartLayer);
        this.stimulateNeuronButton = new HTMLImageButtonNode(NeuronStrings.STIMULATE_BUTTON_CAPTION, new PhetFont(1, 12), CANVAS_BUTTON_COLOR);
        this.stimulateNeuronButton.scale(2.0);
        this.stimulateNeuronButton.setOffset(10.0, 10.0);
        this.addScreenChild(this.stimulateNeuronButton);
        this.stimulateNeuronButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                neuronModel.initiateStimulusPulse();
                NeuronCanvas.this.updateStimButtonState();
            }
        });
        AxonBodyNode axonBodyNode = new AxonBodyNode(neuronModel.getAxonMembrane(), this.mvt);
        this.axonBodyLayer.addChild(axonBodyNode);
        this.axonCrossSectionNode = new AxonCrossSectionNode(neuronModel.getAxonMembrane(), this.mvt);
        this.axonCrossSectionLayer.addChild(this.axonCrossSectionNode);
        for (Particle object : neuronModel.getParticles()) {
            this.addParticle(object);
        }
        for (MembraneChannel membraneChannel : neuronModel.getMembraneChannels()) {
            this.addChannelNode(membraneChannel);
        }
        this.addChargeSymbols();
        this.sodiumExteriorConcentrationReadout = new ConcentrationReadout(new SodiumIon().getRepresentationColor());
        this.concentrationReadoutLayer.addChild(this.sodiumExteriorConcentrationReadout);
        this.sodiumInteriorConcentrationReadout = new ConcentrationReadout(new SodiumIon().getRepresentationColor());
        this.concentrationReadoutLayer.addChild(this.sodiumInteriorConcentrationReadout);
        this.potassiumExteriorConcentrationReadout = new ConcentrationReadout(ColorUtils.darkerColor(new PotassiumIon().getRepresentationColor(), 0.5));
        this.concentrationReadoutLayer.addChild(this.potassiumExteriorConcentrationReadout);
        this.potassiumInteriorConcentrationReadout = new ConcentrationReadout(ColorUtils.darkerColor(new PotassiumIon().getRepresentationColor(), 0.5));
        this.concentrationReadoutLayer.addChild(this.potassiumInteriorConcentrationReadout);
        this.membranePotentialChart = new MembranePotentialChart(POTENTIAL_CHART_SIZE, NeuronStrings.MEMBRANE_POTENTIAL_CHART_TITLE, neuronModel);
        this.membranePotentialChart.setVisible(false);
        this.chartLayer.addChild(this.membranePotentialChart);
        ZoomControl zoomControl = new ZoomControl(new PDimension(25.0, 130.0), this, 0.6, 7.0, 10);
        zoomControl.setOffset(this.stimulateNeuronButton.getXOffset(), this.stimulateNeuronButton.getFullBoundsReference().getMaxY() + 10.0);
        this.chartLayer.addChild(zoomControl);
        this.updateLayout();
        this.updateStimButtonState();
        this.updateChargeSymbolsShown();
        this.updateConcentrationReadoutValues();
        this.updateConcentrationReadoutVisible();
    }

    public void reset() {
        this.setZoomFactor(1.0);
    }

    @Override
    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        Dimension2D dimension2D2 = this.getScreenSize();
        if (dimension2D.getWidth() > 0.0 || dimension2D.getHeight() > 0.0) {
            AffineTransform affineTransform;
            double d = this.getScreenSize().getWidth() / 2.0;
            this.membranePotentialChart.setOffset(d - this.membranePotentialChart.getFullBoundsReference().width / 2.0, dimension2D2.getHeight() - this.membranePotentialChart.getFullBoundsReference().height - 5.0);
            AffineTransform affineTransform2 = this.getWorldTransformStrategy().getTransform();
            try {
                affineTransform = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println(this.getClass().getName() + " - Error: Unable to invert transform.");
                noninvertibleTransformException.printStackTrace();
                affineTransform = new AffineTransform();
            }
            Rectangle2D rectangle2D = affineTransform.createTransformedShape(this.getBounds()).getBounds2D();
            this.viewportInIntermediateCoords.setFrame(rectangle2D);
            this.updateConcentrationReadoutPositions();
        }
    }

    private void updateConcentrationReadoutPositions() {
        PBounds pBounds = this.stimulateNeuronButton.getFullBounds();
        double d = Math.max(this.potassiumExteriorConcentrationReadout.getFullBoundsReference().width, this.sodiumExteriorConcentrationReadout.getFullBoundsReference().width);
        this.potassiumExteriorConcentrationReadout.setOffset(pBounds.getMaxX() + d - this.potassiumExteriorConcentrationReadout.getFullBoundsReference().width + 4.0, pBounds.getY());
        this.sodiumExteriorConcentrationReadout.setOffset(pBounds.getMaxX() + d - this.sodiumExteriorConcentrationReadout.getFullBoundsReference().width + 4.0, this.potassiumExteriorConcentrationReadout.getFullBoundsReference().getMaxY());
        PhetRootPNode phetRootPNode = this.getPhetRootNode();
        Point2D.Double double_ = new Point2D.Double(this.axonCrossSectionNode.getFullBoundsReference().getCenterX(), this.axonCrossSectionNode.getFullBoundsReference().getMinY());
        PAffineTransform pAffineTransform = this.myWorldNode.getTransformReference(false);
        if (pAffineTransform != null) {
            pAffineTransform.transform(double_, double_);
        }
        double d2 = 100.0 + this.myWorldNode.getScale() * 10.0;
        phetRootPNode.worldToScreen(double_);
        double d3 = Math.max(this.potassiumInteriorConcentrationReadout.getFullBoundsReference().width, this.sodiumInteriorConcentrationReadout.getFullBoundsReference().width);
        this.potassiumInteriorConcentrationReadout.setOffset(((Point2D)double_).getX() - d3 / 2.0, ((Point2D)double_).getY() + d2);
        this.sodiumInteriorConcentrationReadout.setOffset(this.potassiumInteriorConcentrationReadout.getFullBoundsReference().getX(), this.potassiumInteriorConcentrationReadout.getFullBoundsReference().getMaxY());
    }

    private void updateStimButtonState() {
        this.stimulateNeuronButton.setEnabled(!this.model.isStimulusInitiationLockedOut());
    }

    private void updateChargeSymbolsShown() {
        this.chargeSymbolLayer.setVisible(this.model.isChargesShown());
    }

    private void updateConcentrationReadoutVisible() {
        this.sodiumExteriorConcentrationReadout.setVisible(this.model.isConcentrationReadoutVisible());
        this.sodiumInteriorConcentrationReadout.setVisible(this.model.isConcentrationReadoutVisible());
        this.potassiumExteriorConcentrationReadout.setVisible(this.model.isConcentrationReadoutVisible());
        this.potassiumInteriorConcentrationReadout.setVisible(this.model.isConcentrationReadoutVisible());
    }

    private void updateConcentrationReadoutValues() {
        String string = this.createConcentrationReadoutText(NeuronStrings.SODIUM_CHEMICAL_SYMBOL, this.model.getSodiumExteriorConcentration());
        this.sodiumExteriorConcentrationReadout.setText(string);
        string = this.createConcentrationReadoutText(NeuronStrings.SODIUM_CHEMICAL_SYMBOL, this.model.getSodiumInteriorConcentration());
        this.sodiumInteriorConcentrationReadout.setText(string);
        string = this.createConcentrationReadoutText(NeuronStrings.POTASSIUM_CHEMICAL_SYMBOL, this.model.getPotassiumExteriorConcentration());
        this.potassiumExteriorConcentrationReadout.setText(string);
        string = this.createConcentrationReadoutText(NeuronStrings.POTASSIUM_CHEMICAL_SYMBOL, this.model.getPotassiumInteriorConcentration());
        this.potassiumInteriorConcentrationReadout.setText(string);
    }

    private String createConcentrationReadoutText(String string, double d) {
        String string2 = NeuronStrings.UNITS_MM;
        String string3 = CONCENTRATION_READOUT_FORMATTER.format(MathUtils.round(d, 5));
        return MessageFormat.format(NeuronStrings.CONCENTRATION_READOUT_PATTERN, string, string3, string2);
    }

    private void addChargeSymbols() {
        ArrayList<MembraneChannel> arrayList = this.model.getMembraneChannels();
        this.sortMembraneChannelList(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addChargeSymbolPair(arrayList.get(i), arrayList.get((i + 1) % arrayList.size()));
        }
    }

    private void addChargeSymbolPair(MembraneChannel membraneChannel, MembraneChannel membraneChannel2) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double(0.0, 0.0);
        this.calcChargeSymbolLocations(membraneChannel.getCenterLocation(), membraneChannel2.getCenterLocation(), double_3, double_2, double_);
        ChargeSymbolNode chargeSymbolNode = new ChargeSymbolNode(this.model, 11.0, 0.1, false);
        chargeSymbolNode.setOffset(this.mvt.modelToViewDouble(double_));
        this.chargeSymbolLayer.addChild(chargeSymbolNode);
        ChargeSymbolNode chargeSymbolNode2 = new ChargeSymbolNode(this.model, 11.0, 0.1, true);
        chargeSymbolNode2.setOffset(this.mvt.modelToViewDouble(double_2));
        this.chargeSymbolLayer.addChild(chargeSymbolNode2);
    }

    private void calcChargeSymbolLocations(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, Point2D point2D5) {
        Point2D.Double double_ = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        double d = Math.sqrt(Math.pow(((Point2D)double_).getX() - point2D3.getX(), 2.0) + Math.pow(((Point2D)double_).getY() - point2D3.getY(), 2.0));
        double d2 = Math.atan2(((Point2D)double_).getY() - point2D3.getY(), ((Point2D)double_).getX() - point2D3.getX());
        double d3 = d + 4.0;
        double d4 = d - 3.0;
        point2D4.setLocation(d3 * Math.cos(d2), d3 * Math.sin(d2));
        point2D5.setLocation(d4 * Math.cos(d2), d4 * Math.sin(d2));
    }

    @Override
    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(ZoomListener.class, zoomListener);
    }

    @Override
    public void setZoomFactor(double d) {
        if (this.zoomFactor != d) {
            this.myWorldNode.setTransform(new AffineTransform());
            double d2 = 1.5;
            if (d > d2) {
                this.myWorldNode.scaleAboutPoint(d, (int)Math.round(NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.width / 2.0), (d - d2) * this.model.getAxonMembrane().getCrossSectionDiameter() * 0.11);
            } else {
                this.myWorldNode.scaleAboutPoint(d, (int)Math.round(NeuronDefaults.INTERMEDIATE_RENDERING_SIZE.width / 2.0), 0.0);
            }
            this.zoomFactor = d;
            this.notifyZoomChanged();
            this.updateConcentrationReadoutPositions();
        }
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    private void addParticle(IViewableParticle iViewableParticle) {
        final ParticleNode particleNode = new ParticleNode(iViewableParticle, this.mvt);
        this.particleLayer.addChild(particleNode);
        iViewableParticle.addListener(new ParticleListenerAdapter(){

            public void removedFromModel() {
                NeuronCanvas.this.particleLayer.removeChild(particleNode);
            }
        });
    }

    private void addChannelNode(MembraneChannel membraneChannel) {
        final MembraneChannelNode membraneChannelNode = new MembraneChannelNode(membraneChannel, this.mvt);
        membraneChannelNode.addToCanvas(this.channelLayer, this.channelEdgeLayer);
        membraneChannel.addListener(new MembraneChannel.Adapter(){});
    }

    private void sortMembraneChannelList(ArrayList<MembraneChannel> arrayList) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                double d;
                Point2D point2D = arrayList.get(i).getCenterLocation();
                Point2D point2D2 = arrayList.get(i + 1).getCenterLocation();
                double d2 = Math.atan2(point2D.getY(), point2D.getX());
                if (!(d2 > (d = Math.atan2(point2D2.getY(), point2D2.getX())))) continue;
                MembraneChannel membraneChannel = arrayList.get(i);
                arrayList.set(i, arrayList.get(i + 1));
                arrayList.set(i + 1, membraneChannel);
                bl = true;
            }
        }
    }

    private void notifyZoomChanged() {
        for (ZoomListener zoomListener : (ZoomListener[])this.listeners.getListeners(ZoomListener.class)) {
            zoomListener.zoomFactorChanged();
        }
    }

    private static class ConcentrationReadout
    extends PText {
        private static final PhetFont READOUT_FONT = new PhetFont(14, true);

        public ConcentrationReadout(Paint paint) {
            this.setFont(READOUT_FONT);
            this.setScale(1.75);
            this.setTextPaint(paint);
        }
    }
}

