/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.gui;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModePanel<T>
extends JPanel {
    public ModePanel(final RecordAndPlaybackModel<T> recordAndPlaybackModel) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(new Color(0, 0, 0, 0));
        final JRadioButton jRadioButton = new JRadioButton(PhetCommonResources.getString("Common.record"), recordAndPlaybackModel.isRecord());
        jRadioButton.setBackground(new Color(0, 0, 0, 0));
        jRadioButton.setFont(new PhetFont(15, true));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                recordAndPlaybackModel.setRecord(true);
            }
        });
        final JRadioButton jRadioButton2 = new JRadioButton(PhetCommonResources.getString("Common.playback"), recordAndPlaybackModel.isPlayback());
        jRadioButton2.setFont(new PhetFont(15, true));
        jRadioButton2.setBackground(new Color(0, 0, 0, 0));
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                recordAndPlaybackModel.setRecord(false);
                recordAndPlaybackModel.rewind();
                recordAndPlaybackModel.setPaused(true);
            }
        });
        this.add(jRadioButton);
        this.add(jRadioButton2);
        recordAndPlaybackModel.addObserver(new SimpleObserver(){

            public void update() {
                jRadioButton.setForeground(ModePanel.this.color(jRadioButton.isSelected() && !recordAndPlaybackModel.isPaused() && !recordAndPlaybackModel.isRecordingFull()));
                jRadioButton2.setForeground(ModePanel.this.color(jRadioButton2.isSelected() && !recordAndPlaybackModel.isPaused()));
                jRadioButton.setSelected(recordAndPlaybackModel.isRecord());
                jRadioButton2.setSelected(recordAndPlaybackModel.isPlayback());
            }
        });
    }

    private Color color(boolean bl) {
        if (bl) {
            return Color.red;
        }
        return Color.black;
    }
}

